/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.drawables.device.v2_1.DeviceFilledRectangle;
import com.roguewave.chart.drawables.device.v2_1.DeviceLines;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import java.awt.Color;

public class LinearGridOverlay
implements ChartOverlay {
    private int firstLine_;
    private int linePeriod_;
    private Color background_ = null;
    private Color gridColor_ = Color.lightGray;
    private Color outlineColor_ = Color.black;
    private boolean showVerticalLines_ = true;

    public LinearGridOverlay(int first, int spacing) {
        this.firstLine_ = first;
        this.linePeriod_ = spacing;
    }

    public void setLineParameters(int firstLine, int linePeriod) {
        this.firstLine_ = firstLine;
        this.linePeriod_ = linePeriod;
    }

    public Color getBackground() {
        return this.background_;
    }

    public void setBackground(Color background) {
        this.background_ = background;
    }

    public int getFirstLine() {
        return this.firstLine_;
    }

    public void setFirstLine(int firstLine) {
        this.firstLine_ = firstLine;
    }

    public Color getGridColor() {
        return this.gridColor_;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor_ = gridColor;
    }

    public int getLinePeriod() {
        return this.linePeriod_;
    }

    public void setLinePeriod(int linePeriod) {
        this.linePeriod_ = linePeriod;
    }

    public Color getOutlineColor() {
        return this.outlineColor_;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor_ = outlineColor;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines_;
    }

    public void setShowVerticalLines(boolean flag) {
        this.showVerticalLines_ = flag;
    }

    public int getItemWidth() {
        return 0;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        int scale2Intervals;
        int scale1Intervals = params1.getHighIncrement() - params1.getLowIncrement();
        ParameterCalculator params = scale1Intervals > (scale2Intervals = params2.getHighIncrement() - params2.getLowIncrement()) ? params1 : params2;
        int lowIncrement = params.getLowIncrement();
        int highIncrement = params.getHighIncrement();
        int pixelsPerIncrement = params.getPixelsPerIncrement();
        int top = base - (highIncrement - lowIncrement) * pixelsPerIncrement;
        int[] x1 = new int[]{left, left, right, right};
        int[] x2 = new int[]{left, right, right, left};
        int[] y1 = new int[]{base, top, top, base};
        int[] y2 = new int[]{top, top, base, base};
        DeviceLines boxLines = new DeviceLines(x1, y1, x2, y2, this.outlineColor_);
        int lineCount = highIncrement - lowIncrement - 1;
        x1 = new int[lineCount];
        x2 = new int[lineCount];
        y1 = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            x1[i] = left;
            x2[i] = right;
            y1[i] = base - (i + 1) * pixelsPerIncrement;
        }
        DeviceLines horizontalLines = new DeviceLines(x1, y1, x2, y1, this.gridColor_);
        if (this.background_ != null) {
            chartGraphics.add2DDrawable(new DeviceFilledRectangle(left, top, right - left, base - top, this.background_));
        }
        chartGraphics.add2DDrawable(horizontalLines);
        int firstLineX = left + offset;
        int columnCount = data.getColumnCount();
        lineCount = 1 + (columnCount - 1 - this.firstLine_) / this.linePeriod_;
        if (lineCount > 0 && this.showVerticalLines_) {
            x1 = new int[lineCount];
            y1 = new int[lineCount];
            y2 = new int[lineCount];
            int index = 0;
            for (int i = this.firstLine_; i < columnCount; i += this.linePeriod_) {
                x1[index] = firstLineX + i * columnWidth;
                y1[index] = base;
                y2[index++] = top;
            }
            DeviceLines verticalLines = new DeviceLines(x1, y1, x1, y2, this.gridColor_);
            chartGraphics.add2DDrawable(verticalLines);
        }
        chartGraphics.add2DDrawable(boxLines);
    }
}

